/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.parsing.ast;

import com.aptana.css.core.parsing.ast.CSSNode;
import com.aptana.css.core.parsing.ast.CSSTextNode;
import com.aptana.css.core.parsing.ast.CSSTreeWalker;
import java.util.Arrays;

public class CSSImportNode
extends CSSNode {
    private String fUriStr;
    private CSSTextNode[] fMediaList;

    public CSSImportNode(String uri, CSSTextNode ... mediaList) {
        this.fUriStr = uri;
        this.fMediaList = mediaList;
    }

    public short getNodeType() {
        return 5;
    }

    public void accept(CSSTreeWalker walker) {
        walker.visit(this);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof CSSImportNode)) {
            return false;
        }
        CSSImportNode other = (CSSImportNode)((Object)obj);
        return this.fUriStr.equals(other.fUriStr) && Arrays.equals((Object[])this.fMediaList, (Object[])other.fMediaList);
    }

    public CSSTextNode[] getMedias() {
        return this.fMediaList;
    }

    public String getUri() {
        return this.fUriStr;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.fUriStr.hashCode();
        hash = hash * 31 + Arrays.hashCode((Object[])this.fMediaList);
        return hash;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("@import ").append(this.getUri());
        CSSTextNode[] medias = this.getMedias();
        int i = 0;
        while (i < medias.length) {
            text.append(' ').append((Object)medias[i]);
            if (i < medias.length - 1) {
                text.append(',');
            }
            ++i;
        }
        text.append(';');
        return text.toString();
    }
}

